package eu.europa.ec.taxud.cesop.readers;

import javax.xml.stream.Location;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Wrapper for {@link javax.xml.stream.Location} that adds pointer to specific xml tag in for of elements path.
 */
public class XmlLocation implements Location {

    private final Location delegate;
    private final List<String> xmlPath;

    /**
     * Instantiates a new Xml location.
     *
     * @param delegate the delegate
     * @param xmlPath  the xml path
     */
    public XmlLocation(Location delegate, List<String> xmlPath) {
        this.delegate = delegate;
        this.xmlPath = Collections.unmodifiableList(new ArrayList<>(xmlPath));
    }

    @Override
    public int getLineNumber() {
        return delegate.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return delegate.getColumnNumber();
    }

    @Override
    public int getCharacterOffset() {
        return delegate.getCharacterOffset();
    }

    @Override
    public String getPublicId() {
        return delegate.getPublicId();
    }

    @Override
    public String getSystemId() {
        return delegate.getSystemId();
    }

    /**
     * Gets xml path.
     *
     * @return the xml path
     */
    public List<String> getXmlPath() {
        return xmlPath;
    }
}
